This repository provides the official implementation of our proposed method FABLE, based on the [PFLlib]([新建标签页](https://github.com/TsingZ0/PFLlib)) — a Personalized Federated Learning Library and Benchmark.

We conduct experiments on the datasets provided by PFLlib, including CIFAR10，CIFAR100，AG News and Sogou News. We utilize the ResNet18, ResNet 34 and Transformer models for vision and language tasks.

The data can be preprocessed into IID and non-IID formats using the following commands:

```bash
cd ../dataset
python generate_Cifar100.py iid balance - # for iid and balanced scenario
python generate_Cifar100.py noniid - dir # for practical noniid and unbalanced scenario
```

To run FABLE on a specific dataset and setting, use the following command:

```bash
python main.py -data Cifar100 -m resnet34 -algo FABLE -gr 500 -did 0
```

For other datasets or models, modify the `-data` and `-m` arguments accordingly.

To run baselines, simply replace `--algo FABLE` with the respective method name in the above command.

